import service from '@/utils/request/index'
import type { BackendServicePageResult, PageSearchParams } from '@/utils/request/types'
import type { ShopItem, YaBiData } from './types'
/**
 * 积分商城列表
 */
export const getShopItemList = (data: PageSearchParams) => {
  return service.request<BackendServicePageResult<ShopItem>>({
    url: '/api/culture/shop/item/pageList',
    method: 'POST',
    data,
  })
}

/**
 * 获取用户YA币兑换记录
 */
export const getYabiExchangeList = (data: PageSearchParams) => {
  return service.request<BackendServicePageResult<any>>({
    url: '/api/culture/action/record/yabiList',
    method: 'POST',
    data,
  })
}

/**
 * 获取用户亚币相关数据
 */
export const getYaBiData = () => {
  return service.request<YaBiData>({
    url: '/api/culture/action/record/yabiData',
    method: 'POST',
    data: {},
  })
}
