import { defineStore } from 'pinia'

import { getTagList } from '@/api'

/**
 * 关于标签的store
 */
export const useTagsStore = defineStore('tags', () => {
  const tagList = ref<{ label: string; value: number }[]>([])

  let isLoading = false

  const fetchTagList = async () => {
    if (isLoading) return
    isLoading = true
    try {
      const { data } = await getTagList()
      tagList.value = data.map((item) => ({
        label: item.title,
        value: item.id,
      }))
    } catch (error) {
      console.error(error)
    } finally {
      isLoading = false
    }
  }

  return { tagList, fetchTagList }
})
