async function getInfo() {
  const res = await fetch('/version.json?t=' + Date.now())
  const data = await res.json()
  return data as { version: string; updateInfo: string }
}

export async function loopGetVersion() {
  const { version } = await getInfo()
  let hasShow = false
  let timer: NodeJS.Timeout | null = null
  timer = setInterval(async () => {
    const { version: newVersion, updateInfo: newUpdateInfo } = await getInfo()
    if (newVersion === version) return
    if (hasShow) {
      if (timer) {
        clearInterval(timer)
      }
      return
    }
    ElNotification({
      title: '更新提示',
      type: 'primary',
      offset: 50,
      duration: 0,
      message: () =>
        h('div', [
          h('div', { class: 'flex items-center' }, [
            '有新版本更新，请',
            h(
              ElLink,
              {
                type: 'primary',
                underline: false,
                onClick: () => {
                  window.location.reload()
                },
              },
              '刷新',
            ),
            '页面',
            ,
          ]),
          newUpdateInfo &&
            h(
              'div',
              { class: 'mt-1' },
              newUpdateInfo.split(' ').map((str) => h('div', str)),
            ),
        ]),
    })
    hasShow = true
  }, 10000)
}
