import service from '@/utils/request/index'
import type {
  AddOrUpdateColumnDto,
  BackendColumnSearchParams,
  BackendColumnListItemDto,
} from './types'
import type { BackendServicePageResult } from '@/utils/request/types'
// 后台管理栏目相关内容

/**
 * 新增或者修改栏目
 */
export const addOrUpdateColumn = (data: AddOrUpdateColumnDto) => {
  return service.request({
    url: '/api/cultureColumn/addOrUpdate',
    method: 'POST',
    data,
  })
}

/**
 * 栏目列表
 */
export const listOfCultureColumn = (data: BackendColumnSearchParams) => {
  return service.request<BackendServicePageResult<BackendColumnListItemDto>>({
    url: '/api/cultureColumn/listByPage',
    method: 'POST',
    data,
  })
}

/**
 * 删除栏目设置
 */
export const deleteColumn = (ids: number[]) => {
  return service.request<boolean>({
    url: `/api/cultureColumn/delete`,
    method: 'POST',
    data: ids,
  })
}
/**
 * 隐藏栏目设置
 */
export const hideColumn = (ids: number[]) => {
  return service.request<boolean>({
    url: `/api/cultureColumn/hidden`,
    method: 'POST',
    data: ids,
  })
}
