import { defineStore } from 'pinia'
import { loginByEmail } from '@/api/login'
import type { LoginResponseDto } from '@/api/login/types'
/**
 * 关于用户的store
 */
export const useUserStore = defineStore('user', () => {
  const userInfo = ref({} as LoginResponseDto)
  const token = ref('')
  // 获取用户信息
  const fetchUserInfo = async () => {
    const { data } = await loginByEmail({
      email: 'lijiabin@yswg.com.cn',
      password: 'Lijiabin123.',
    })
    setUserInfo(data)
  }
  const setUserInfo = (info: LoginResponseDto) => {
    userInfo.value = info
  }
  const setToken = (str: string) => {
    token.value = str
  }

  return { userInfo, token, fetchUserInfo, setUserInfo, setToken }
})
