import {
  ArticleTypeEnum,
  ReleaseStatusTypeEnum,
  BooleanFlag,
  SendTypeEnum,
  VideoPositionEnum,
} from '@/constants'
import type { PageSearchParams } from '@/utils/request/types'

/**
 * 搜索文章的参数
 */
export interface ArticleSearchParams extends PageSearchParams {
  type?: ArticleTypeEnum
  sortLogic?: number
  title?: string
  questionFocus?: number
}

/**
 * 添加或更新文章DTO（带枚举版本）
 */
export type AddOrUpdateArticleDto =
  | AddOrUpdatePostDto
  | AddOrUpdateColumnDto
  | AddOrUpdateInterviewDto
  | AddOrUpdateVideoDto

/**
 * 添加帖子的DTO
 */
export interface AddOrUpdatePostDto {
  id?: number
  title?: string
  content?: string
  releaseStatus?: ReleaseStatusTypeEnum
  sendType?: SendTypeEnum
  faceUrl?: string
  imgUrl?: string
  sendTime?: string
  type?: ArticleTypeEnum.POST
}

interface AddOrUpdateColumnBase {
  id?: number
  type: ArticleTypeEnum.COLUMN
  title: string
  content: string
  releaseStatus: ReleaseStatusTypeEnum
  sendType: SendTypeEnum
  faceUrl?: string
  imgUrl?: string
  // 关联的专栏栏目
  relateColumnId?: number
  mainTagId: string
  isRelateColleague: BooleanFlag
  sendTime?: string
  isRecommend: BooleanFlag
}

/**
 * 添加专栏的原始form类型
 */
export interface AddOrUpdateColumnForm extends AddOrUpdateColumnBase {
  tagList: number[]
}

/**
 * 添加专栏的DTO
 */
export interface AddOrUpdateColumnDto extends AddOrUpdateColumnBase, PushSettingBase {
  tagList: { tagId: number; sort: number }[]
}

export interface AddOrUpdateInterviewBase {
  id?: number
  type: ArticleTypeEnum.INTERVIEW
  title: string
  content: string
  releaseStatus: ReleaseStatusTypeEnum
  sendType: SendTypeEnum
  faceUrl?: string
  imgUrl?: string
  // 关联的专访栏目
  relateColumnId?: number
  mainTagId: string
  sendTime?: string
  isRecommend: BooleanFlag
}

export interface AddOrUpdateInterviewForm extends AddOrUpdateInterviewBase {
  tagList: number[]
}

interface PushSettingBase {
  pushType: SendTypeEnum
  pushTime: string
  pushList: { valueId: string; valueName: string | number }[]
}
// 推送设置相关的字段
/**
 * 添加专访的DTO
 */
export interface AddOrUpdateInterviewDto extends AddOrUpdateInterviewBase, PushSettingBase {
  tagList: { tagId: number; sort: number }[]
}

export interface AddOrUpdateVideoDto {
  id?: number
  title: string
  type: ArticleTypeEnum.VIDEO
  content: string
  videoUrl: string
  videoDuration: string
  releaseStatus: ReleaseStatusTypeEnum
  sendType: SendTypeEnum
  faceUrl?: string
  imgUrl?: string
  sendTime?: string
  isRecommend?: BooleanFlag
  mainTagId: string | number
  tagList: { tagId: number; sort: number }[] | number[]
  relateColumnId?: number
}

/**
 * 添加专访的DTO
 */

/**
 *  文章详情
 */

export interface ArticleItemDto {
  id: number
  title: string
  content: string
  faceUrl: string
  videoUrl: string
  description: string
  createUserId: string
  createTime: number
  viewCount: number
  playCount: number
  isRecommend: BooleanFlag
  type: ArticleTypeEnum
  isRelateColleague: BooleanFlag
  releaseStatus: ReleaseStatusTypeEnum
  tagNameList: string[]
  praiseCount: number
  collectionCount: number
  replyCount: number
  hasPraised: boolean
  hasCollect: boolean
  imgUrl: string
  createUserAvatar: string
  createUserName: string
  showAvatar: string
  showName: string
  videoDuration: string
  showComment?: boolean
  relateColumn?: string
  rewardNum: number
  isExpand: boolean
  hasAddQuestion: boolean
  cultureCommentListVo: {
    articleId: number
    avatar: string
    children: string
    childrenNum: number
    content: string
    createTime: number
    createUserId: number
    description: string
    faceUrl: string
    hasPraise: BooleanFlag
    hiddenAvatar: string
    hiddenName: string
    id: number
    isFeatured: BooleanFlag
    isRecommend: BooleanFlag
    isTop: BooleanFlag
    pid: number
    postPriseCount: number
    praiseCount: number
    region: string
    regionHide: BooleanFlag
    replyId: number
    replyName: string
    replyUser: string
    title: string
    type: ArticleTypeEnum
    userId: string
    viewCount: number
    childNum: number
  }
  relateColumnId: number
  sendType: SendTypeEnum
  sendTime: string
  tagIdList: number[]
  pushList: { valueId: string; valueType: number; valueName: string }[]
  videoLocation: VideoPositionEnum
  articleVideoUrl: string
}

/**
 * 专栏选项
 */
export interface ColumnOptionDto {
  color: string
  createTime: number
  createUserId: number
  id: number
  isDelete: BooleanFlag
  sort: number
  status: BooleanFlag
  title: string
  type: 'column'
}

/**
 * 专栏列表Item
 */
export interface ColumnItemDto {
  title: string
  color: string
  sort: number
  id: number
  yaColumnVoList: {
    articleId: number
    collectCount: number
    content: string
    createTime: number
    description: string
    faceUrl: string
    hasPraised: boolean
    isRecommend: number
    praiseCount: number
    replyCount: number
    title: string
    type: ArticleTypeEnum.COLUMN
    viewCount: number
    videoDuration: string
    showName: string
    showAvatar: string
    playCount: number
  }[]
}

/**
 * 专访选项
 */
export interface InterviewOptionDto {
  color: string
  createTime: number
  createUserId: number
  id: number
  isDelete: BooleanFlag
  sort: number
  status: BooleanFlag
  title: string
  type: 'column'
}
/**
 * 视频选项
 */

export interface VideoOptionDto {
  color: string
  createTime: number
  createUserId: number
  id: number
  isDelete: BooleanFlag
  sort: number
  status: BooleanFlag
  title: string
  type: 'video'
}

/**
 * 专访列表Item
 */
export interface InterviewItemDto {
  title: string
  color: string
  sort: number
  yaColumnVoList: {
    articleId: number
    collectCount: number
    content: string
    createTime: number
    description: string
    faceUrl: string
    hasPraised: boolean
    isRecommend: number
    praiseCount: number
    replyCount: number
    title: string
    type: ArticleTypeEnum.INTERVIEW
    viewCount: number
  }[]
}

/**
 * 视频选项
 */
/**
 * 评论列表
 */
export interface CommentSearchParams extends PageSearchParams {
  articleId: number | string
  sortType: number
}
/**
 * 获取子评论列表
 */
export interface CommentChildrenSearchParams extends PageSearchParams {
  pid: number | string
  articleId: number | string
}

/**
 * 新增评论
 */
export interface AddCommentDto {
  articleId: number | string
  content: string
  pid?: number | string
  imgUrl?: string
}

/**
 * 评论信息
 */
export interface CommentItemDto {
  articleId: number
  avatar: string
  children: CommentItemDto[]
  content: string
  createTime: number
  hasPraise: BooleanFlag
  hiddenAvatar: string
  hiddenName: string
  id: number
  isFeatured: number
  isTop: number
  pid: number
  postPriseCount: number
  region: string
  regionHide: number
  replyUser: string
  replyName: string
  userId: string
  isHaveChildren: BooleanFlag
  childrenNum: number
  showChildrenPage: boolean
  childrenPageCurrent: number
  childrenPageList: CommentItemDto[]
  loadingChildren: boolean
  showComment: boolean
  isExpand: boolean
  childNum: number
  imgUrl: string
}

/**
 * 搜索更多专栏查询参数
 */
export interface SearchMoreColumnParams extends PageSearchParams {
  columnId: number
  sortLogic: number
  title?: string
}

/**
 * 搜索更多专栏返回参数
 */
export interface SearchMoreColumnItemDto {
  articleId: number
  collectCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  isRecommend: number
  playCount: number
  praiseCount: number
  replyCount: number
  showAvatar: string
  showName: string
  title: string
  type: ArticleTypeEnum.COLUMN
  videoDuration: string
  viewCount: number
}

/**
 * 搜索更多视频查询参数
 */
export interface SearchMoreVideoParams extends PageSearchParams {
  columnId: number | string
  sortLogic: number
  title?: string
}

/**
 * 搜索更多视频返回参数
 */
export interface SearchMoreVideoItemDto {
  articleId: number
  collectCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  isRecommend: number
  playCount: number
  praiseCount: number
  replyCount: number
  showAvatar: string
  showName: string
  title: string
  type: ArticleTypeEnum.VIDEO
  videoDuration: string
  viewCount: number
}

/**
 * 获取问吧二级评论的返回参数
 */
export type SecondCommentItemDto = CommentItemDto
