import type { ArticleType, BooleanFlag } from '@/constants'
import { useUserStore } from '@/stores'
import { storeToRefs } from 'pinia'
/**
 * 页面改变标题
 * @param title
 */
export function changeAppTitle(title: string) {
  document.title = title
}

/**
 * 判断设备，判断是 ios 还是 安卓
 */
export function checkUserAgent() {
  const agent = navigator.userAgent
  const isAndroid = agent.indexOf('Android') > -1 || agent.indexOf('Linux') > -1
  const isIOS = !!agent.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/)
  if (isAndroid) {
    return 'android'
  }
  if (isIOS) {
    return 'ios'
  }
  return ''
}

/**
 * 判断设备，判断是 移动端 还是 PC端
 */
export function isMoible() {
  const UA = navigator.userAgent

  if (window.innerWidth < 500) {
    return true
  }

  return !!/(Android|webOS|iPhone|iPod|tablet|BlackBerry|Mobile)/i.test(UA)
}

/**
 * 将颜色转成 rgb 的 三个数字，逗号分割
 * @param {*} hex 颜色
 * @returns  255,255,255
 */
export function hexToRgb(hex: string) {
  // 去除可能包含的 # 符号
  hex = hex.replace(/^#/, '')

  // 将 HEX 转换为 RGB
  const bigint = parseInt(hex, 16)
  const r = (bigint >> 16) & 255
  const g = (bigint >> 8) & 255
  const b = bigint & 255

  // 返回 RGB 格式的颜色
  return `${r}, ${g}, ${b}`
}

// 当前路径是否是企业文化
export function isCulturePath() {
  const path = window.location.pathname
  return path.includes('/culture')
}

// 点击头像跳转用户首页
export function jumpToUserHomePage({ userId, isReal }: { userId: number; isReal: BooleanFlag }) {
  const userStore = useUserStore()
  const { userInfo } = storeToRefs(userStore)
  const isSelf = userInfo.value.userId === userId
  if (isSelf) {
    window.open(`/userPage/selfPublish`)
  } else {
    window.open(`/otherUserPage/${userId}/${isReal}`)
  }
}

// 根据文章类型跳到对应的文章详情页面
export function jumpToArticleDetailPage({ type, id }: { type: ArticleType; id: number }) {
  if (type === 'video') {
    window.open(`/videoDetail/${id}`)
  } else if (type === 'question') {
    window.open(`/questionDetail/${id}`)
  } else {
    window.open(`/articleDetail/${id}`)
  }
}
