import { ArticleTypeEnum, ReleaseStatusEnum, BooleanFlag } from '@/constants'
import type { PageSearchParams } from '@/utils/request/types'

/**
 * 搜索文章的参数
 */
export interface ArticleSearchParams extends PageSearchParams {
  type?: ArticleTypeEnum
}

/**
 * 添加或更新文章DTO（带枚举版本）
 */
export interface AddOrUpdateArticleDto {
  /** 内容 */
  content?: string

  /** 创建人id */
  createUserId?: number

  /** 描述 */
  description?: string

  /** 封面图 */
  faceUrl?: string

  /** id，编辑时必传 */
  id?: number

  /** 是否关联同事 */
  isRelateColleague?: number

  /** 主标签id */
  mainTagId?: number

  /** 发布状态 */
  releaseStatus?: ReleaseStatusEnum

  /** 标签列表 */
  tagList?: { tagId: number; sort: number }[]

  /** 标题 */
  title?: string

  /** 文章类型 */
  type?: ArticleTypeEnum

  /** 视频url */
  videoUrl?: string
}

/**
 *  文章详情
 */

// 更严格的类型定义
export interface ArticleItemDto {
  id: number
  title: string
  content: string
  faceUrl: string
  videoUrl: string
  description: string
  createUserId: number
  createTime: number
  viewCount: number
  isRecommend: BooleanFlag
  type: ArticleTypeEnum
  isRelateColleague: BooleanFlag
  releaseStatus: ReleaseStatusEnum
  tagNameList: string[]
  praiseCount: number
  collectionCount: number
  replyCount: number
  hasPraised: BooleanFlag
}
