// 常规的接口
import service from '@/utils/request/index'
import type { FielItemDto } from './types'
/**
 * 获取常规的接口
 */
export const uploadFile = (file: File, onProgress?: (progress: number) => void) => {
  const formData = new FormData()
  formData.append('file', file)
  return service.request<FielItemDto>({
    url: '/mobiles/file-upload/singleUpload',
    method: 'POST',
    data: formData,
    onUploadProgress: (progressEvent) => {
      const percentCompleted = Math.round((progressEvent.loaded * 100) / (progressEvent.total || 1))
      onProgress?.(percentCompleted)
    },
  })
}
