import { defineStore } from 'pinia'
import { getTagList } from '@/api'
import type { TagItemDto } from '@/api/tag/types'
/**
 * 关于标签的store
 */
export const useTagsStore = defineStore('tags', () => {
  // 文化关键词标签
  const tagList = ref<TagItemDto[]>([])

  // 关联场景相关的标签
  const relatedScenariosTagList = ref<TagItemDto[]>([])
  let isLoading = false

  const fetchAllTagList = async () => {
    if (isLoading) return
    isLoading = true
    try {
      const { data } = await getTagList()
      tagList.value = data.filter((i) => i.type === 'culture')
      relatedScenariosTagList.value = data.filter((i) => i.type === 'related_scenarios')
      console.log(tagList.value, 'tagList')
    } catch (error) {
      console.error(error)
    } finally {
      isLoading = false
    }
  }
  // 手动调用一次
  fetchAllTagList()

  return { tagList, fetchAllTagList, relatedScenariosTagList }
})
