import service from '@/utils/request/index'
import type { AddOrUpdateTagDto, BackendTagListItemDto, BackendTagSearchParams } from './types'
import type { BackendServicePageResult } from '@/utils/request/types'
// 后台管理标签相关接口

/**
 * 获取标签列表 分页
 */
export const getTagList = (params: BackendTagSearchParams) => {
  return service.request<BackendServicePageResult<BackendTagListItemDto>>({
    url: '/api/cultureTag/listByPage',
    method: 'POST',
    data: params,
  })
}

/**
 * 新增或者更新标签
 */
export const addOrUpdateTag = (data: AddOrUpdateTagDto) => {
  return service.request({
    url: '/api/cultureTag/addOrUpdate',
    method: 'POST',
    data,
  })
}

/**
 * 删除标签
 */
export const deleteTag = (id: number) => {
  return service.request<boolean>({
    url: `/api/cultureTag/delete?id=${id}`,
    method: 'POST',
  })
}
