export * from './wxLogin'
export * from './initWXConfig'
import * as ww from '@wecom/jssdk'

/**
 * 分享
 */
interface IShareWxOption {
  /** 分享标题 */
  title: string
  /** 分享链接 */
  link: string
  /** 分享描述 */
  desc?: string
  /** 分享封面 */
  imgUrl?: string
}
// export function wxShare(option: IShareWxOption) {
//   const url = location.href.split('#')[0]
//   option.link = url + '#' + option.link
//   wx.invoke('shareAppMessage', option, function (res: any) {
//     if (res.err_msg == 'openExistedChatWithMsg:ok') {
//       console.log(res)
//     }
//   })
// }
export function wxShare(option: IShareWxOption) {
  const url = location.href.split('#')[0]
  option.link = ww.shareAppMessage({
    title: '测试一下',
    desc: '让每个企业都有自己的微信',
    link: url + '#' + option.link,
    imgUrl: 'https://res.mail.qq.com/node/ww/wwmng/style/images/index_share_logo$13c64306.png',
  })
}

/**
 * 企业微信获取部门人员SDK
 * @params wxOption 企业微信 selectEnterpriseContact 的选项
 * @params wxOption.fromDepartmentId 必填，表示打开的通讯录从指定的部门开始展示，-1表示自己所在部门开始, 0表示从最上层开始
 * @params wxOption.mode  必填，选择模式，single表示单选，multi表示多选
 * @params wxOption.type 必填，选择限制类型，指定department、user中的一个或者多个
 * @params wxOption.selectedDepartmentIds 非必填，已选部门ID列表。用于多次选人时可重入，single模式下请勿填入多个id
 * @params wxOption.selectedUserIds 非必填，已选用户ID列表。用于多次选人时可重入，single模式下请勿填入多个id
 * @returns
 */
interface ISelectDepOrUser {
  err_msg: string
  result: {
    userList: ISelectUser[]
  }
}
interface ISelectUser {
  id: string
  name: string
  avatar: string
}
export function selectDepOrUser(wxOption = {}): Promise<ISelectDepOrUser> {
  const defaultOption = {
    fromDepartmentId: -1,
    mode: 'single',
    type: ['user', 'department'],
    // "selectedDepartmentIds": [],
    // "selectedUserIds": checkPerson
  }
  const option = {
    ...defaultOption,
    ...wxOption,
  }
  return new Promise((resolve, reject) => {
    ww.invoke('selectEnterpriseContact', option, function (res: ISelectDepOrUser) {
      if (res.err_msg == 'selectEnterpriseContact:ok') {
        resolve(res)
      }
    })
  })
}
