import service from '@/utils/request/index'
import type { UpdateUserInfoDto } from './types'
import type {
  BackendServicePageResult,
  BackendServiceResult,
  PageSearchParams,
} from '@/utils/request/types'

/**
 * 更新用户信息
 */
export const updateUserInfo = (data: UpdateUserInfoDto) => {
  return service.request({
    url: '/api/personalCenter/updateUser',
    method: 'POST',
    data,
  })
}

/**
 * 是否有官方账号权限
 */
export const hasOfficialAccount = () => {
  return service.request<[]>({
    url: '/api/personalCenter/getIsOfficial',
    method: 'POST',
    data: {},
  })
}

/**
 * 获取我的收藏列表
 */
export const getSelfCollectList = (data: PageSearchParams) => {
  return service.request<
    BackendServicePageResult<{
      id: number
      title: string
      content: string
      createTime: string
      updateTime: string
    }>
  >({
    url: '/api/personalCenter/selfCollect',
    method: 'POST',
    data,
  })
}

/**
 * 获取我的点赞列表
 */
export const getSelfPraiseList = (data: PageSearchParams) => {
  return service.request<
    BackendServicePageResult<{
      id: number
      title: string
      content: string
      createTime: string
      updateTime: string
    }>
  >({
    url: '/api/personalCenter/selfPraise',
    method: 'POST',
    data,
  })
}
