// 文章类型枚举
export enum ArticleTypeEnum {
  VIDEO = 'video', // 视频
  POST = 'post', // 帖子
  QUESTION = 'question', // 问题
  COLUMN = 'column', // 专栏
  PRACTICE = 'practice', // 实践
  INTERVIEW = 'interview', // 专访
}

// 发布状态枚举
export enum ReleaseStatusEnum {
  DRAFT = 1, // 草稿
  PUBLISH = 2, // 发布
}

// 任务类型枚举
export enum TaskTypeEnum {
  // 常规任务
  REGULAR_TASK = 1,
  // 特殊任务
  SPECIAL_TASK = 2,
}

// 商品类型枚举
export enum ShopGoodsTypeEnum {
  // 实物
  REAL_GOODS = 1,
  // 虚拟
  VIRTUAL_GOODS = 2,
}

// 布尔值枚举
export enum BooleanFlag {
  NO = 0, // 否
  YES = 1, // 是
}

// 发送类型枚举
export enum SendTypeEnum {
  // 立即发送
  IMMEDIATE = 1,
  // 定时发送
  SCHEDULED = 2,
}

// 任务日期限制类型枚举
export enum TaskDateLimitTypeEnum {
  // 每日
  DAY = 'DAY',
  // 每周
  WEEK = 'WEEK',
  // 每月
  MONTH = 'MONTH',
}
