import { createRouter, createWebHistory } from 'vue-router'
import layoutCulture from '@/layoutCulture/index.vue'
const routes = [
  {
    path: '/',
    name: 'Layout',
    component: layoutCulture,
    redirect: '/homePage/homeTab',
    meta: {
      title: '企业文化首页',
    },
    children: [
      {
        path: 'homePage',
        name: 'CultureHomePage',
        // component: () => import('@/layoutCulture/components/mainContainer.vue'),
        component: () => import('@/views/homePage/index.vue'),
        children: [
          {
            path: 'homeTab',
            name: 'CultureHomeTab',
            component: () => import('@/views/homePage/homeTab/index.vue'),
          },
          {
            path: 'yaTab',
            name: 'CultureYaTab',
            component: () => import('@/views/homePage/yaTab/index.vue'),
          },
          {
            path: 'askTab',
            name: 'CultureAskTab',
            component: () => import('@/views/homePage/askTab/index.vue'),
          },
        ],
      },
      {
        path: 'videoDetail/:',
        name: 'CultureVideoDetail',
        component: () => import('@/views/videoDetail/index.vue'),
      },
      {
        path: 'pointsStore',
        name: 'CulturePointsStore',
        component: () => import('@/views/pointsStore/index.vue'),
      },
      {
        path: 'postDetail/:articleId',
        name: 'CulturePostDetail',
        component: () => import('@/views/postDetail/index.vue'),
      },
      // 发布视频
      {
        path: 'publishVideo',
        name: 'CulturePublishVideo',
        component: () => import('@/views/publishVideo/index.vue'),
      },
      // 个人中心
      {
        path: 'userPage',
        name: 'CultureUserPage',
        component: () => import('@/views/userPage/index.vue'),
      },
      // 去投稿
      {
        path: 'publishCase',
        name: 'CulturePublishCase',
        component: () => import('@/views/publishCase/index.vue'),
      },
      // 发布文章
      // {
      // {
      //   path: 'deshboard',
      //   name: 'CultureHome',
      //   component: () => import('@/views/home/index.vue')
      // },
      // {
      //   path: 'ya',
      //   name: 'CultureYa',
      //   component: () => import('@/views/ya/index.vue')
      // },
      // {
      //   path: 'ask',
      //   name: 'CultureAsk',
      //   component: () => import('@/views/ask/index.vue')
      // }
    ],
  },
]

const scrollPositionMap = new Map<string, number>()

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes,
  scrollBehavior(to, from, savedPosition) {
    return new Promise((resolve) => {
      // console.log(to, from, savedPosition)
      // 如果有浏览器保存的位置（前进/后退），优先使用
      if (savedPosition) {
        resolve(savedPosition)
        return
      }

      // 如果有锚点，滚动到锚点
      if (to.hash) {
        resolve({ el: to.hash })
        return
      }

      // 检查是否有保存的滚动位置
      const savedScrollY = scrollPositionMap.get(to.fullPath)
      if (savedScrollY !== undefined) {
        resolve({ top: savedScrollY })
        return
      }

      // 默认滚动到顶部
      resolve({ top: 0 })
    })
  },
})
// 在路由离开前保存当前滚动位置
router.beforeEach((to, from, next) => {
  // 保存当前页面的滚动位置
  if (from.fullPath) {
    scrollPositionMap.set(from.fullPath, window.scrollY)
  }
  next()
})

export default router
