/**
 * 确认兑换商品的弹窗内容
 */
import { ShopGoodsTypeEnum, regionListOptions } from '@/constants'
import type { ShopItem } from '@/api'
import type { SetupContext } from 'vue'
import ask from '@/assets/img/culture/ask.png'

type ExchangeContentProps = {
  item: ShopItem
  type: ShopGoodsTypeEnum
  modelValue: string
}
type ExchangeContentEvents = {
  'update:modelValue'(message: string): void
}

export default function ExchangeContent(
  { item, modelValue, type }: ExchangeContentProps,
  context: SetupContext<ExchangeContentEvents>,
) {
  return (
    <div class="exchange-content py-6">
      {/* 商品图片区域 - 同上 */}
      <div class="flex justify-center mb-8">
        <div class="relative">
          <div class="w-32 h-32 bg-gradient-to-br from-orange-100 to-pink-100 rounded-3xl flex items-center justify-center">
            <div class="w-20 h-20 bg-white rounded-2xl flex items-center justify-center shadow-sm">
              <img src={ask} alt={item.name} class="w-16 h-16 object-contain" />
            </div>
          </div>
          <div class="absolute -top-2 -right-2 w-7 h-7 bg-blue-500 rounded-full flex items-center justify-center">
            <span class="text-white text-sm font-medium">6</span>
          </div>
        </div>
      </div>

      {/* 商品信息 */}
      <div class="space-y-4 mb-8">
        <div class="flex items-center justify-center gap-3">
          <div class="w-1.5 h-1.5 bg-gray-400 rounded-full"></div>
          <span class="text-gray-600 text-sm">名称：</span>
          <span class="font-medium text-gray-900">{item.name}</span>
        </div>

        <div class="flex items-center justify-center gap-3">
          <div class="w-1.5 h-1.5 bg-orange-400 rounded-full"></div>
          <span class="text-gray-600 text-sm">积分：</span>
          <span class="font-semibold text-orange-500 text-lg">{item.price}YA币</span>
        </div>
      </div>

      {/* 办公点选择 */}
      {type === ShopGoodsTypeEnum.REAL_GOODS && (
        <div class="mb-6">
          <div class="text-center text-gray-700 text-sm font-medium mb-4">选择办公点：</div>
          <div class=" w-full">
            <el-select
              modelValue={modelValue}
              onUpdate:modelValue={(value: string) => context.emit('update:modelValue', value)}
              placeholder="请选择办公点"
            >
              {regionListOptions.map((office) => (
                <el-option
                  class="text-center w-full"
                  key={office.value}
                  label={office.label}
                  value={office.value}
                />
              ))}
            </el-select>
          </div>
        </div>
      )}
    </div>
  )
}

ExchangeContent.props = {
  item: {
    type: Object as PropType<ShopItem>,
    required: true,
  },
  modelValue: {
    type: String,
    required: false,
  },
  type: {
    type: Number,
    required: true,
  },
}

ExchangeContent.emits = {
  'update:modelValue': (value: string) => value,
}
