import { uploadFile } from '@/api'

// 默认参数
export const useUploadImg = (imgList: Ref<string[]> = ref([])) => {
  const uploadPercent = ref(0)
  // 字符串拼
  const imgsStr = computed(() => imgList.value.join(','))

  // 上传图片的change事件
  const handleFileChange = async (e: Event) => {
    const file = (e.target as HTMLInputElement).files?.[0]
    if (!file) return

    const { promise } = uploadFile(file, {
      onProgress: (progress) => {
        uploadPercent.value = progress
      },
    })
    const data = await promise
    imgList.value.push(data.filePath)

    uploadPercent.value = 0
    // 重置input的value
    ;(e.target as HTMLInputElement).value = ''
  }

  // 删除图片
  const handleDeleteImg = (urlStr: string) => {
    imgList.value = imgList.value.filter((item) => item !== urlStr)
  }

  return {
    imgsStr,
    imgList,
    handleFileChange,
    uploadPercent,
    handleDeleteImg,
  }
}
