import type { PageSearchParams } from '@/utils/request/types'
import { BooleanFlag, AuctionStatusEnum } from '@/constants'

export interface BackendAuctionListSearchParams extends PageSearchParams {
  name?: string
  status?: AuctionStatusEnum
}

export interface BackendAuctionListItemDto extends PageSearchParams {
  bidLimit: number
  canBid: number
  cannotBidReason: string
  createAt: number
  createUserName: string
  currentBidderId: number
  currentPrice: number
  description: string
  endTime: number
  id: number
  imageUrl: string
  isDisplay: number
  minIncrement: number
  name: string
  quantity: number
  specification: string
  startTime: number
  startingPrice: number
  status: AuctionStatusEnum
  statusDesc: string
  totalBids: number
  type: number
  typeDesc: string
  userBidCount: number
  // 拍卖剩余时间 几天 几个小时 几分钟 几秒
  remainingTime: string
}

export interface BackendAddOrUpdateAuctionItemDto {
  id?: number
  name: string
  quantity: number
  specification: string
  description: string
  startingPrice: number
  minIncrement: number
  bidLimit: number
  startTime: string
  endTime: string
  isDisplay: BooleanFlag
  imageUrl: string
}

export interface BackendAuctionRecordItemDto extends PageSearchParams {
  id: number
  bidPrice: number
  bidTime: number
  isHighest: number
  itemId: number
  status: number
  userId: number
  userName: string
}
