import service from '@/utils/request/index'
import { getBackendAuctionList } from '@/api/backend'
import type { AuctionItemDetailDto } from './types'
// 前台限时竞拍相关接口

/**
 * 限时竞拍前台列表
 */
export const getAuctionList = getBackendAuctionList

/**
 * 获取用户某个商品的拍卖次数是否超过限制
 */
export const getUserAuctionCount = (id: number) => {
  return service.request<boolean>({
    url: `api/cultureAuctionItems/isOver`,
    method: 'POST',
    data: {
      id,
    },
  })
}

/**
 * 获取某个商品的竞拍信息详情
 */
export const getAuctionDetail = (id: number) => {
  return service.request<AuctionItemDetailDto>({
    url: `api/cultureAuctionItems/getAuctionItemDetail?id=${id}`,
    method: 'POST',
  })
}

/**
 * 参与竞价
 */
export const participateAuction = (id: number, bidPrice: number) => {
  return service.request({
    url: `api/cultureAuctionItems/auction`,
    method: 'POST',
    data: {
      id,
      bidPrice,
    },
  })
}
