import service from '@/utils/request/index'
import type { AddOrUpdateCaseDto, CaseDetailDto } from './types'

// 案例库相关的接口

/**
 * 获取最新的案例编号
 */
export const getMaxCaseNumber = () => {
  return service.request<string>({
    url: '/api/cultureCase/getMaxCaseNumber',
    method: 'POST',
    data: {},
  })
}

/**
 * 新增案例库
 */
export const addOrUpdateCase = (data: AddOrUpdateCaseDto) => {
  return service.request({
    url: '/api/cultureCase/addOrUpdateCase',
    method: 'POST',
    data,
  })
}

/**
 * 获取案例详情
 */
export const getCaseDetail = (id: number) => {
  return service.request<CaseDetailDto>({
    url: `/api/cultureCase/getCaseDetail?caseId=${id}`,
    method: 'POST',
  })
}

/**
 * 删除案例库
 */
export const deleteCase = (id: number) => {
  return service.request({
    url: `/api/cultureCase/deleteCase?id=${id}`,
    method: 'POST',
  })
}
