import { ArticleTypeEnum, AuditStatusEnum, BooleanFlag } from '@/constants'
import type { PageSearchParams } from '@/utils/request/types'

export interface SelfPublishSearchParams extends PageSearchParams {
  type: ArticleTypeEnum
}
// 我的发布
export interface SelfPublishDetailDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  id: number
  isRecommend: boolean
  isRelateColleague: boolean
  praiseCount: number
  releaseStatus: number
  replyCount: number
  tagNameList: string[]
  title: string
  type: string
  videoUrl: string
  viewCount: number
}

// 我的收藏
export interface SelfCollectSearchParams extends PageSearchParams {
  type: ArticleTypeEnum
}

export interface SelfCollectDetailDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  id: number
  isRecommend: boolean
  praiseCount: number
  replyCount: number
  tagNameList: string[]
  title: string
  type: string
  viewCount: number
}

// 我的点赞
export interface SelfPraiseSearchParams extends PageSearchParams {
  type: ArticleTypeEnum
}

export interface SelfPraiseDetailDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  id: number
  isRecommend: boolean
  isRelateColleague: boolean
  praiseCount: number
  releaseStatus: number
  replyCount: number
  tagNameList: string[]
  title: string
  type: string
  videoUrl: string
  viewCount: number
}

// 我的草稿 详情
export interface SelfDraftDetailDto {
  id: number
  title: string
  content: string
  createTime: string
  updateTime: string
}

export interface UpdateUserInfoDto {
  hiddenAvatar: string
  hiddenName: string
  signature: string
}

// 审核列表查询参数
export interface AuditListSearchParams extends PageSearchParams {
  isAudit: AuditStatusEnum
}

// 待审核列表item
export interface AuditListItemDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  id: number
  imgUrl: string
  isRecommend: boolean
  isRelateColleague: boolean
  playCount: number
  praiseCount: number
  relateColumnId: string
  releaseStatus: AuditStatusEnum
  replyCount: number
  showAvatar: string
  showName: string
  tagNameList: string[]
  title: string
  type: string
  viewCount: number
}

/**
 * 审核推文参数
 */
export interface AuditArticleDto {
  articleId: number
  auditResult: Exclude<AuditStatusEnum, AuditStatusEnum.UNAUDITED>
  auditRemark?: string
}

/**
 * 官方账号Item
 */
export interface OfficialAccountItemDto {
  account: string
  address: string
  avatar: string
  birthday: string
  createTime: null
  createUser: null
  deptId: number
  directLeader: string
  email: string
  entryDate: null
  hadFansPoint: number
  hiddenAvatar: string
  hiddenName: string
  interactiveMessageCount: number
  isOfficialAccount: BooleanFlag
  isReceiveMsg: BooleanFlag
  jobNumId: string
  level: number
  loginTime: null
  name: null
  officialTag: string
  password: null
  passwordChangeStatus: number
  passwordUpdateTime: null
  phone: null
  region: string
  regionHide: BooleanFlag
  roleId: string
  salt: null
  sex: null
  signature: null
  status: string
  updateTime: string
  updateUser: number
  userId: number
  version: null
}
