import type { Plugin } from 'vite'
import fs from 'node:fs'
import path from 'node:path'

export default function pushUpdatePlugin(): Plugin {
  return {
    name: 'push-update-plugin',
    apply: 'build',
    writeBundle(options) {
      const version = Date.now().toString()

      const outDir = options.dir || path.resolve(process.cwd(), 'dist')
      const filePath = path.resolve(outDir, 'version.json')
      fs.writeFileSync(
        filePath,
        JSON.stringify({ version }, null, 2), // 存成 json
        'utf-8',
      )
    },
  }
}

async function getVersion() {
  const res = await fetch('/version.json?t=' + Date.now())
  const data = await res.json()
  return data.version
}

export async function loopGetVersion() {
  const version = await getVersion()
  let hasShow = false
  let timer: NodeJS.Timeout | null = null
  timer = setInterval(async () => {
    const newVersion = await getVersion()
    if (newVersion === version) return
    if (hasShow) {
      if (timer) {
        clearInterval(timer)
      }
      return
    }
    ElNotification({
      title: '更新提示',
      type: 'primary',
      offset: 50,
      duration: 0,
      message: () =>
        h('div', { class: 'flex items-center' }, [
          '有新版本更新，请',
          h(
            ElLink,
            {
              type: 'primary',
              underline: false,
              onClick: () => {
                window.location.reload()
              },
            },
            '刷新',
          ),
          '页面',
        ]),
    })
    hasShow = true
  }, 10000)
}
