import { BooleanFlag } from '@/constants'

/**
 * 轮播图的item
 */
export interface CarouselItemDto {
  articleId: number
  assetUrl: string
  isRelease: BooleanFlag
  sort: number
  type: BooleanFlag
  url: string
}

/**
 * 用户相关数据
 */
export interface UserAccountDataDto {
  ayabiAvailable: number
  ayabiTotal: number
  createTime: number
  expTotal: number
  id: number
  isDelete: number
  level: number
  remark: string
  updateTime: number
  userId: string
}

/**
 * 用户信息记录
 */
export interface UserRecordDataDto {
  actionType: null
  actionTypeText: null
  createdAt: null
  createdTimeText: null
  currentValue: null
  id: null
  incrText: null
  isDelete: null
  isIncr: null
  isSign: BooleanFlag
  relationId: null
  remark: null
  scoreAyabi: null
  scoreExp: null
  subType: null
  userId: null
}
