import {
  ArticleTypeEnum,
  AuditStatusEnum,
  BooleanFlag,
  CommentTypeEnum,
  ReleaseStatusTypeEnum,
  TaskDateLimitTypeEnum,
  TaskTypeEnum,
} from '@/constants'
import type { PageSearchParams } from '@/utils/request/types'

export interface SelfPublishSearchParams extends PageSearchParams {
  type: ArticleTypeEnum
}
// 我的发布
export interface SelfPublishDetailDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  id: number
  isRecommend: boolean
  isRelateColleague: boolean
  praiseCount: number
  releaseStatus: number
  replyCount: number
  tagNameList: string[]
  title: string
  type: ArticleTypeEnum
  videoUrl: string
  viewCount: number
}

// 我的收藏
export interface SelfCollectSearchParams extends PageSearchParams {
  type: ArticleTypeEnum
}

export interface SelfCollectDetailDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  id: number
  isRecommend: boolean
  praiseCount: number
  replyCount: number
  tagNameList: string[]
  title: string
  type: ArticleTypeEnum
  viewCount: number
}

// 我的点赞
export interface SelfPraiseSearchParams extends PageSearchParams {
  type: ArticleTypeEnum
}

// 我的案例库搜索
export interface SelfCaseSearchParams extends PageSearchParams {
  releaseStatus: ReleaseStatusTypeEnum
}

export interface SelfPraiseDetailDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  id: number
  isRecommend: boolean
  isRelateColleague: boolean
  praiseCount: number
  releaseStatus: number
  replyCount: number
  tagNameList: string[]
  title: string
  type: string
  videoUrl: string
  viewCount: number
}

//草稿搜索
export interface SelfDraftSearchParams extends PageSearchParams {
  type: ArticleTypeEnum
}

// 我的草稿 详情
export interface SelfDraftDetailDto {
  id: number
  title: string
  content: string
  createTime: string
  updateTime: string
}

export interface UpdateUserInfoDto {
  hiddenAvatar: string
  hiddenName: string
  signature: string
}

// 审核列表查询参数
export interface AuditListSearchParams extends PageSearchParams {
  isAudit: AuditStatusEnum
}

// 待审核列表item
export interface AuditListItemDto {
  collectionCount: number
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraised: boolean
  id: number
  imgUrl: string
  isRecommend: boolean
  isRelateColleague: boolean
  playCount: number
  praiseCount: number
  relateColumnId: string
  releaseStatus: AuditStatusEnum
  replyCount: number
  showAvatar: string
  showName: string
  tagNameList: string[]
  title: string
  type: ArticleTypeEnum
  viewCount: number
}

/**
 * 审核推文参数
 */
export interface AuditArticleDto {
  articleId: number
  auditResult: AuditStatusEnum
  auditRemark?: string
}

/**
 * 官方账号Item
 */
export interface OfficialAccountItemDto {
  account: string
  address: string
  avatar: string
  birthday: string
  createTime: null
  createUser: null
  deptId: number
  directLeader: string
  email: string
  entryDate: null
  hadFansPoint: number
  hiddenAvatar: string
  hiddenName: string
  interactiveMessageCount: number
  isOfficialAccount: BooleanFlag
  isReceiveMsg: BooleanFlag
  jobNumId: string
  level: number
  loginTime: null
  name: null
  officialTag: string
  password: null
  passwordChangeStatus: number
  passwordUpdateTime: null
  phone: null
  region: string
  regionHide: BooleanFlag
  roleId: string
  salt: null
  sex: null
  signature: null
  status: string
  updateTime: string
  updateUser: number
  userId: number
  version: null
}

/**
 * 我的案例库列表
 */
export interface SelfCaseItemDto {
  caseType: string
  content: string
  createTime: number
  createUser: number
  cultureKeywordMain: string
  cultureKeywordSecond: string
  cultureRelation: number
  dataSources: number
  deptId: string
  deptName: string
  id: number
  integrity: number
  isAudit: AuditStatusEnum
  isDelete: number
  isDispose: number
  isUse: number
  mainScene: string
  minorScene: string
  number: string
  sceneKeywordMain: string
  sceneKeywordSecond: string
  sourceProject: string
  sourceTime: number
  sourceType: string
  sourceUser: number
  title: string
  yearKeywordMain: null
  yearKeywordSecond: null
}

/**
 * 我的评论列表查询参数
 */
export interface SelfCommentSearchParams extends PageSearchParams {
  messageType: CommentTypeEnum
  type: ArticleTypeEnum
}

/**
 * 我的评论列表
 */
export interface SelfCommentItemDto {
  articleId: number
  avatar: string
  children: null
  content: string
  createTime: number
  createUserId: number
  description: string
  faceUrl: string
  hasPraise: boolean
  hiddenAvatar: string
  hiddenName: string
  id: number
  isFeatured: boolean
  isRecommend: boolean
  isTop: boolean
  pid: number
  postPriseCount: number
  region: string
  regionHide: boolean
  replyId: number
  replyName: string
  replyUser: string
  title: string
  type: ArticleTypeEnum
  userId: number
  viewCount: number
}

// 我的任务
export interface SelfTaskSearchParams extends PageSearchParams {
  taskType: TaskTypeEnum
}
export interface SelfTaskItemDto {
  completedTasks: number
  currentCount: number
  description: string
  id: number
  jumpUrl: string
  limitCount: number
  limitType: TaskDateLimitTypeEnum
  periodKey: string
  rewardType: number
  rewardValue: number
  status: number
  svgName: string
  taskKey: string
  taskType: number
  title: string
  totalTasks: number
}

/**
 * 举报列表item
 */
export interface ComplaintListItemDto {
  articleId: number
  auditId: number
  auditName: string
  auditTime: number
  createId: number
  createName: string
  createTime: number
  id: number
  isDelete: number
  reason: string
  showAvatar: string
  showName: string
  status: number
  title: string
  type: ArticleTypeEnum
}

/**
 * 举报列表搜索参数
 */
export interface ComplaintListSearchParams extends PageSearchParams {
  status: AuditStatusEnum
}

/**
 * 审核举报
 */
export interface AuditComplaintDto {
  id: number
  status: AuditStatusEnum
  remark?: string
}
