import service from '@/utils/request/index'
import type {
  BackendAuctionListSearchParams,
  BackendAuctionListItemDto,
  BackendAddOrUpdateAuctionItemDto,
  BackendAuctionRecordItemDto,
} from './types'
import type { BackendServicePageResult } from '@/utils/request/types'
import { BooleanFlag } from '@/constants'
// 后台管理限时竞拍相关接口

/**
 * 限时竞拍后台列表
 */
export const getBackendAuctionList = (data: BackendAuctionListSearchParams) => {
  return service.request<BackendServicePageResult<BackendAuctionListItemDto>>({
    url: '/cultureAuctionItems/listByPage',
    method: 'POST',
    data,
  })
}

/**
 * 新增或者编辑竞拍物品
 */
export const addOrUpdateAuctionItem = (data: BackendAddOrUpdateAuctionItemDto) => {
  return service.request({
    url: '/cultureAuctionItems/addOrUpdateAuctionItem',
    method: 'POST',
    data,
  })
}

/**
 * 删除竞拍物品数据
 */
export const deleteAuction = (idList: number[]) => {
  return service.request({
    url: '/cultureAuctionItems/deleteAuction',
    method: 'POST',
    data: { idList },
  })
}

/**
 * 批量修改展示竞拍
 */
export const batchUpdateShowAuction = (data: { idList: number[]; isDisplay: BooleanFlag }) => {
  return service.request({
    url: '/cultureAuctionItems/changeAuctionDisplay',
    method: 'POST',
    data,
  })
}

/**
 * 获取竞拍记录
 */
export const getAuctionRecord = (data: BackendAuctionRecordItemDto) => {
  return service.request<BackendServicePageResult<BackendAuctionRecordItemDto>>({
    url: `/cultureAuctionItems/listBidRecord`,
    method: 'POST',
    data,
  })
}
