import service from '@/utils/request/index'
import type { BackendServicePageResult } from '@/utils/request/types'
import type {
  ExchangeGoodsParams,
  ExchangeGoodsRecordItemDto,
  ShopSearchParams,
  YaBiData,
  ExchangeYabiRecordItemDto,
  ExchangeGoodsRecordSearchParams,
  BackendShopItemDto,
  ExchangeYabiRecordSearchParams,
} from './types'
/**
 * 获取用户亚币相关数据
 */
export const getYaBiData = () => {
  return service.request<YaBiData>({
    url: '/api/culture/action/record/yabiData',
    method: 'POST',
    data: {},
  })
}

/**
 * 积分商城商品列表
 */
export const getShopItemList = (data: ShopSearchParams) => {
  return service.request<BackendServicePageResult<BackendShopItemDto>>({
    url: '/api/culture/shop/item/pageList',
    method: 'POST',
    data,
  })
}

/**
 * 兑换商品
 */
export const exchangeGoods = (data: ExchangeGoodsParams) => {
  return service.request({
    url: '/api/culture/shop/item/exchange',
    method: 'POST',
    data,
  })
}

/**
 * 商品领取列表
 */
export const getExchangeGoodsRecordList = (data: ExchangeGoodsRecordSearchParams) => {
  return service.request<BackendServicePageResult<ExchangeGoodsRecordItemDto>>({
    url: '/api/culture/shop/order/exchangeList',
    method: 'POST',
    data,
  })
}

/**
 * 获取用户YA币兑换记录
 */
export const getExchangeYabiRecordList = (data: ExchangeYabiRecordSearchParams) => {
  return service.request<BackendServicePageResult<ExchangeYabiRecordItemDto>>({
    url: '/api/culture/action/record/yabiList',
    method: 'POST',
    data,
  })
}
