import emojis from './face.json'

function escapeHTML(str: string) {
  return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;')
}

export const parseEmoji = (content: string) => {
  if (!content) return ''

  let html = escapeHTML(content)

  emojis.forEach((item) => {
    const escapedName = item.name.replace(/[.*+?^${}()|[\]\\]/g, '\\$&')

    const reg = new RegExp(escapedName, 'g')

    html = html.replace(
      reg,
      `<img
        src="${item.url}"
        alt="${item.name}"
        class="${item.className || 'emoji_small'} inline-block align-text-bottom w-6 h-6"
      />`,
    )
  })

  return html
}
