import type { PageSearchParams } from '@/utils/request/types'
import { BooleanFlag, ShopGoodsTypeEnum } from '@/constants'

/**
 * 商品列表搜索参数
 */
export interface ShopSearchParams extends PageSearchParams {
  region: string
  itemType: ShopGoodsTypeEnum
}

/**
 * 积分商城商品类型
 */
export interface BackendShopItemDto {
  createTime: number
  description: string
  enable: BooleanFlag
  id: number
  imageUrl: string
  itemType: ShopGoodsTypeEnum
  itemTypeName: string
  name: string
  price: number
  region: string
  soldOut: boolean
  sortOrder: number
  stock: number
}

/**
 * 商品领取列表搜索参数
 */
export interface ExchangeGoodsRecordSearchParams extends PageSearchParams {
  receiveTimeStart: number
  receiveTimeEnd: number
  itemType: ShopGoodsTypeEnum
}

/**
 * yabi信息对象类型
 */
export interface YaBiData {
  actionType: null
  actionTypeText: null
  createdAt: null
  createdTimeText: null
  currentValue: number
  id: null
  incrText: null
  isDelete: null
  isIncr: null
  isSign: null
  relationId: null
  remark: null
  scoreAyabi: null
  scoreExp: null
  subType: null
  userId: null
}

/**
 * 兑换商品请求参数类型
 */
export interface ExchangeGoodsParams {
  itemId: number
  num: number
  deliveryInfo?: string
}

/**
 * 商品领取列表item Dto
 */
export interface ExchangeGoodsRecordItemDto {
  createTime: number
  deliveryInfo: string
  id: number
  isDelete: BooleanFlag
  itemId: number
  itemName: string
  itemType: ShopGoodsTypeEnum
  num: number
  price: number
  status: number
  userId: number
}

/**
 * 获取用户YA币收支记录
 */
export interface ExchangeYabiRecordItemDto {
  actionType: string
  actionTypeText: string
  createdAt: number
  createdTimeText: string
  currentValue: number
  id: number
  incrText: string
  isDelete: BooleanFlag
  isIncr: BooleanFlag
  isSign: BooleanFlag
  relationId: number
  remark: string
  scoreAyabi: number
  scoreExp: number
  subType: string
  userId: number
}

/**
 * 获取用户YA币兑换记录搜索参数
 */
export interface ExchangeYabiRecordSearchParams extends PageSearchParams {
  type: ShopGoodsTypeEnum
  startTime?: number
  endTime?: number
}
