import { defineStore } from 'pinia'
import { getYaBiData } from '@/api'
import type { YaBiData } from '@/api'
/**
 * 关于用户ya币的store
 */
export const useYaBiStore = defineStore('yabi', () => {
  // 用户ya币数据
  const yabiData = ref({} as YaBiData)

  let isLoading = false

  const fetchYaBiData = async () => {
    if (isLoading) return
    isLoading = true
    try {
      const { data } = await getYaBiData()
      yabiData.value = data
    } catch (error) {
      console.error(error)
    } finally {
      isLoading = false
    }
  }
  // 手动调用一次
  fetchYaBiData()

  return { yabiData, fetchYaBiData }
})
