import layoutCulture from '@/layoutCulture/index.vue'

export const constantsRoute = [
  {
    path: '/',
    name: 'Layout',
    component: layoutCulture,
    redirect: '/homePage/homeTab',
    meta: {
      title: '企业文化首页',
    },
    children: [
      {
        path: 'homePage',
        name: 'CultureHomePage',
        // component: () => import('@/layoutCulture/components/mainContainer.vue'),
        component: () => import('@/views/homePage/index.vue'),
        children: [
          {
            path: 'homeTab',
            name: 'CultureHomeTab',
            component: () => import('@/views/homePage/homeTab/index.vue'),
          },
          {
            path: 'yaTab',
            name: 'CultureYaTab',
            component: () => import('@/views/homePage/yaTab/index.vue'),
          },
          {
            path: 'askTab',
            name: 'CultureAskTab',
            component: () => import('@/views/homePage/askTab/index.vue'),
          },
        ],
      },
      // 个人中心
      {
        path: 'userPage',
        name: 'CultureUserPage',
        redirect: '/userPage/selfPublish',
        component: () => import('@/views/userPage/index.vue'),
        children: [
          // 我的帖子
          {
            path: 'selfPublish',
            name: 'CultureSelfPublish',
            component: () => import('@/views/userPage/components/selfPublish.vue'),
          },
          // 我的草稿
          {
            path: 'selfDraft',
            name: 'CultureSelfDraft',
            component: () => import('@/views/userPage/components/selfDraft.vue'),
          },
          // 我的收藏
          {
            path: 'selfCollect',
            name: 'CultureSelfCollect',
            component: () => import('@/views/userPage/components/selfCollect.vue'),
          },
          // 我的点赞
          {
            path: 'selfPraise',
            name: 'CultureSelfPraise',
            component: () => import('@/views/userPage/components/selfPraise.vue'),
          },
          // 我的案例库
          {
            path: 'selfCase',
            name: 'CultureSelfCase',
            component: () => import('@/views/userPage/components/selfCase.vue'),
          },
          // 我的任务
          {
            path: 'selfTask',
            name: 'CultureSelfTask',
            component: () => import('@/views/userPage/components/selfTask.vue'),
          },
          // 参与活动
          {
            path: 'selfActivity',
            name: 'CultureSelfActivity',
            component: () => import('@/views/userPage/components/selfActivity.vue'),
          },
          // 评论回复
          {
            path: 'selfComment',
            name: 'CultureSelfComment',
            component: () => import('@/views/userPage/components/selfComment.vue'),
          },
          // 回答问题
          {
            path: 'selfAnswer',
            name: 'CultureSelfAnswer',
            component: () => import('@/views/userPage/components/selfAnswer.vue'),
          },
          // 审核帖子列表
          {
            path: 'selfAudit',
            name: 'CultureSelfAudit',
            component: () => import('@/views/userPage/components/selfAudit.vue'),
          },
          // 审核举报列表
          {
            path: 'selfComplaint',
            name: 'CultureSelfComplaint',
            component: () => import('@/views/userPage/components/selfComplaint.vue'),
          },
        ],
      },
      // 点进去其他用户的个人中心
      {
        path: 'otherUserPage/:userId/:isReal',
        name: 'CultureOtherUserPage',
        component: () => import('@/views/otherUserPage/index.vue'),
      },
      {
        path: 'videoDetail/:id',
        name: 'CultureVideoDetail',
        component: () => import('@/views/videoDetail/index.vue'),
      },
      {
        path: 'articleDetail/:id',
        name: 'CultureArticleDetail',
        component: () => import('@/views/articleDetail/index.vue'),
      },
      {
        path: 'pointsStore',
        name: 'CulturePointsStore',
        component: () => import('@/views/pointsStore/index.vue'),
      },

      // 发布视频
      {
        path: 'publishVideo',
        name: 'CulturePublishVideo',
        component: () => import('@/views/publishVideo/index.vue'),
      },

      // 去投稿
      {
        path: 'publishCase',
        name: 'CulturePublishCase',
        component: () => import('@/views/publishCase/index.vue'),
      },
      // 搜索页面
      {
        path: 'searchPage',
        name: 'CultureSearchPage',
        component: () => import('@/views/searchPage/index.vue'),
      },
      // 审核
      {
        path: 'auditArticle/:id',
        name: 'CultureAuditArticle',
        component: () => import('@/views/auditArticle/index.vue'),
      },
      // YA文化专栏的搜索
      {
        path: 'columnSearchList/:id',
        name: 'CultureColumnSearchList',
        component: () => import('@/views/columnSearchList/index.vue'),
      },
      // YA文化实践的搜索
      {
        path: 'practiceSearchList',
        name: 'CulturePracticeSearchList',
        component: () => import('@/views/practiceSearchList/index.vue'),
      },
      // YA文化视频的搜索
      {
        path: 'videoSearchList/:id?',
        name: 'CultureVideoSearchList',
        component: () => import('@/views/videoSearchList/index.vue'),
      },
      {
        path: 'questionDetail/:id',
        name: 'CultureQuestionDetail',
        component: () => import('@/views/questionDetail/index.vue'),
      },
      {
        path: 'publishLongArticle/:type',
        name: 'CulturePublishLongArticle',
        component: () => import('@/views/publishLongArticle/index.vue'),
      },
      // 限时竞拍
      {
        path: 'auction',
        name: 'Auction',
        component: () => import('@/views/auction/index.vue'),
      },
    ],
  },

  {
    path: '/backend',
    name: 'Backend',
    component: () => import('@/views/backend/index.vue'),
    redirect: '/backend/tags',
    children: [
      {
        path: 'manager',
        name: 'ManagerManagement',
        component: () => import('@/views/backend/manager/index.vue'),
        meta: { title: '企业文化管理员' },
      },
      {
        path: 'tags',
        name: 'OfficialManagement',
        component: () => import('@/views/backend/tags/index.vue'),
        meta: { title: '官方标签' },
      },
      {
        path: 'carousel',
        name: 'CarouselManagement',
        component: () => import('@/views/backend/carousel/index.vue'),
        meta: { title: '轮播图设置' },
      },
      // {
      //   path: 'topic-admin',
      //   name: 'TopicAdminManagement',
      //   component: () => import('@/views/backend/topic-admin/index.vue'),
      //   meta: { title: '专栏——管理员' },
      // },
      // {
      //   path: 'interview-admin',
      //   name: 'InterviewAdminManagement',
      //   component: () => import('@/views/backend/interview-admin/index.vue'),
      //   meta: { title: '专访——管理员' },
      // },
      // {
      //   path: 'videoManage',
      //   name: 'VideoManageManagement',
      //   component: () => import('@/views/backend/videoManage/index.vue'),
      //   meta: { title: '视频管理' },
      // },
      {
        path: 'caseManage',
        name: 'CaseManageManagement',
        component: () => import('@/views/backend/caseManage/index.vue'),
        meta: { title: 'YAYA案例库管理' },
      },
      {
        path: 'goodsDistribution',
        name: 'GoodsDistributionManagement',
        component: () => import('@/views/backend/goodsDistribution/index.vue'),
        meta: { title: '积分商城——商品分发' },
      },

      /**
       * 内容管理下的子菜单
       */
      // 专栏管理
      {
        path: 'contentsMenu/columnManage',
        name: 'ContentsColumnManage',
        component: () => import('@/views/backend/contentsMenu/columnManage/index.vue'),
        meta: { title: '专栏管理' },
      },
      // 专访管理
      {
        path: 'contentsMenu/interviewManage',
        name: 'ContentsInterviewManage',
        component: () => import('@/views/backend/contentsMenu/interviewManage/index.vue'),
        meta: { title: '专访管理' },
      },
      // 视频管理
      {
        path: 'contentsMenu/videoManage',
        name: 'ContentsVideoManage',
        component: () => import('@/views/backend/contentsMenu/videoManage/index.vue'),
        meta: { title: '视频管理' },
      },
      // 问吧管理
      {
        path: 'contentsMenu/questionManage',
        name: 'ContentsQuestionManage',
        component: () => import('@/views/backend/contentsMenu/questionManage/index.vue'),
        meta: { title: '问吧管理' },
      },
      /**
       * 配置管理下的子菜单
       */
      // 积分商城配置
      {
        path: 'settingsMenu/goodsManage',
        name: 'GoodsManageManagement',
        component: () => import('@/views/backend/settingsMenu/goodsManage/index.vue'),
        meta: { title: '积分商城配置' },
      },
      // 限时竞拍配置
      {
        path: 'settingsMenu/auctionManage',
        name: 'AuctionManageManagement',
        component: () => import('@/views/backend/settingsMenu/auctionManage/index.vue'),
        meta: { title: '限时竞拍配置' },
      },
      /**
       * 栏目管理下的子菜单
       */
      // 专栏——栏目管理
      {
        path: 'columnsMenu/columnManage',
        name: 'ColumnManage',
        component: () => import('@/views/backend/columnsMenu/columnManage/index.vue'),
        meta: { title: '专栏——栏目管理' },
      },
      // 专访——栏目管理
      {
        path: 'columnsMenu/interviewManage',
        name: 'InterviewManage',
        component: () => import('@/views/backend/columnsMenu/interviewManage/index.vue'),
        meta: { title: '专访——栏目管理' },
      },
      // 视频——栏目管理
      {
        path: 'columnsMenu/videoManage',
        name: 'VideoManage',
        component: () => import('@/views/backend/columnsMenu/videoManage/index.vue'),
        meta: { title: '视频——栏目管理' },
      },
    ],
  },
]
